package polestaticutil;

import java.util.Arrays;

public class PoleUtilitySimple {

    private PoleUtilitySimple() {
        //chceme pouze čistě statickou třídu => neumožníme volat konstruktor
        //proto je konstruktor private
    }

    static int soucetPole(int[] pole) {
        int soucet = 0;
        for (int i = 0; i < pole.length; i++) {
            soucet += pole[i];
        }
        return soucet;
    }

    static double prumerPole(int[] pole) {
        return (int) soucetPole(pole) / pole.length;
    }

    static int indexMaximaPole(int[] pole) {
        int indexMaxima = 0;
        for (int i = 1; i < pole.length; i++) {
            if (pole[i] > pole[indexMaxima]) {
                indexMaxima = i;
            }
        }
        return indexMaxima;
    }

    static int maximumPole(int[] pole) {
        return pole[indexMaximaPole(pole)];
    }

    static int indexMinimaPole(int[] pole) {
        int indexMinima = 0;
        for (int i = 1; i < pole.length; i++) {
            if (pole[i] < pole[indexMinima]) {
                indexMinima = i;
            }
        }
        return indexMinima;
    }

    static int minimumPole(int[] pole) {
        return pole[indexMinimaPole(pole)];
    }

    static int[] duplikujPole(int[] pole) {
        int[] duplikat = new int[pole.length];
        for (int i = 0; i < duplikat.length; i++) {
            duplikat[i] = pole[i];
        }
        return duplikat;
    }

    static void invertujPole(int[] pole) {
        int pom;
        for (int i = 0; i < pole.length / 2; i++) {
            pom = pole[i];
            pole[i] = pole[(pole.length - 1) - i];
            pole[(pole.length - 1) - i] = pom;
        }
    }

    static void seradPoleVzestupne(int[] pole) {
        Arrays.sort(pole);
    }

    static void seradPoleSestupne(int[] pole) {
        Arrays.sort(pole);
        invertujPole(pole);
    }

    static void vypis(int[] pole) {
        for (int i = 0; i < pole.length; i++) {
            System.out.print("[" + i + "] = " + pole[i]);
            if (i < pole.length - 1) {//neni to posledni prvek
                System.out.print(", ");
            }
        }
        System.out.println("");
    }
}
